const elementIndexRegex = /([a-zA-Z0-9\\-]*)\[(\d)\]/


// This function handles arrays and objects
//DH: modified to only affect main package name at top of manifest.
function replacePackageName( manifest, oldPackageName, newPackageName ) 
{
  function recursiveReplace (objSource) 
  {
    // if it is a string we check if we replace if it fits the package name
    if (typeof objSource === 'string' && objSource==oldPackageName ) {
      return objSource.replace(oldPackageName, newPackageName)
    }

    // for objects we go deeper
    if( typeof objSource === 'object') 
    {
      if (objSource === null) {
        return null
      }

      Object.keys(objSource).forEach(function (property) {
        objSource[property] = recursiveReplace(objSource[property])
      })

      return objSource
    }

    // in all other cases we just keep the value as is
    return objSource
  }

  return recursiveReplace(manifest)
}


function goDeeper (elements, element) {
  let elementIndex = null
  const matcher = element.match(elementIndexRegex)
  if (matcher) {
    elementIndex = Number(matcher[2])
    element = matcher[1]
  }

  let resultElement = null

  // check if the element just directly exists
  if (elements[element]) {
    resultElement = elements[element]
  } else {
    // if not we are dealing with an array, we have to check if our element is in there
    for (const k in elements) {
      if (elements[k].name === element) {
        resultElement = elements[k]
        break
      }
    }

    // because of the format of the file we have to also check if there is a child array
    if (elements.child) {
      elements = elements.child
      let count = 0
      for (const k in elements) {
        if (!elements[k].element) { // this could be a text node, we can not check those
          continue
        }
        if (elements[k].element.name === element) {
          if (elementIndex === null || elementIndex === count) {
            return elements[k].element
          }
          count++
        }
      }
    }
  }

  if (elementIndex !== null) {
    return resultElement[elementIndex]
  }
  return resultElement
}

function getElementsAtPath (manifest, path) {
  const pathElements = path.split('.')

  // the root manifestt always starts with an `element` object
  for (let i = 0; i < pathElements.length; i++) {
    manifest = goDeeper(manifest, pathElements[i])
    if (manifest === null) {
      // means the path is wrong
      throw new Error(`element does not exist ${pathElements[i]}`)
    }
  }

  return manifest
}

function setAttributesAtPath (manifest, path, attributeMap) {
  manifest = getElementsAtPath(manifest, path)

  for (const k in attributeMap) {
    const attributeElements = k.split('.')
    let dataToEdit = manifest
    for (let i = 0; i < attributeElements.length; i++) {
      dataToEdit = goDeeper(dataToEdit, attributeElements[i])
    }
    dataToEdit.value = attributeMap[k]
    
    //DH: Modify compiled parts too.
    if( dataToEdit.compiledItem && dataToEdit.compiledItem.prim.intDecimalValue ) 
        dataToEdit.compiledItem.prim.intDecimalValue = parseInt(dataToEdit.value)
    else if( dataToEdit.compiledItem && dataToEdit.compiledItem.prim.booleanValue ) 
        dataToEdit.compiledItem.prim.booleanValue = (dataToEdit.value=='true')
  }
}

//DH: Delete any perms that are not in the given list
function deleteUnsusedPermissions (manifest, permissions) {
  for (const k in manifest.element.child) {
    if (manifest.element.child[k].element && manifest.element.child[k].element.name === 'uses-permission' 
        && !permissions.includes( manifest.element.child[k].element.attribute[0].value ) ) {
      manifest.element.child.splice(k, 1)
    }
  }
}

//DH: Modified to take list of desired perms to delete.
function deletePermissions (manifest, permissions) {
  for (const k in manifest.element.child) {
    if (manifest.element.child[k].element && manifest.element.child[k].element.name === 'uses-permission' 
        //&& manifest.element.child[k].element.attribute[0].value === permission) {
        && permissions.includes( manifest.element.child[k].element.attribute[0].value ) ) {
      manifest.element.child.splice(k, 1)
      //return
    }
  }
}

function deleteActivityByName (manifest, name) {
  manifest = getElementsAtPath(manifest, 'element.application')

  for (const k in manifest.child) {
    if (manifest.child[k].element && manifest.child[k].element.name === 'activity') {
      for (const attrIdx in manifest.child[k].element.attribute) {
        if (manifest.child[k].element.attribute[attrIdx].value === name) {
          //delete manifest.child[k].element
          manifest.child.splice(k,1)
          return
        }
      }
    }
  }
}

//DH: Delete a service given it's full name.
function deleteServiceByName (manifest, name) {
  manifest = getElementsAtPath(manifest, 'element.application')

  for (const k in manifest.child) {
    if (manifest.child[k].element && manifest.child[k].element.name === 'service') {
      for (const attrIdx in manifest.child[k].element.attribute) {
        if (manifest.child[k].element.attribute[attrIdx].value === name) {
          //delete manifest.child[k].element
          manifest.child.splice(k,1)
          return
        }
      }
    }
  }
}

//DH: Delete services not in given list. (untested)
function deleteUnsusedServices( manifest, names ) 
{
  manifest = getElementsAtPath(manifest, 'element.application')

  for (const k in manifest.child) {
    if (manifest.child[k].element && manifest.child[k].element.name === 'service') {
      for (const attrIdx in manifest.child[k].element.attribute) {
        if( !names.includes( manifest.child[k].element.attribute[attrIdx].value) )
        {
          //delete manifest.child[k].element
          manifest.child.splice(k,1)
        }
      }
    }
  }
}

///DH: Delet intent filters according to activity/index
function deleteIntentByIndex( manifest, activity, indexes, offset ) 
{
  manifest = getElementsAtPath(manifest, 'element.application')
  
  var deletes = 0
  for( i in indexes ) indexes[i]+=offset
  
  for (const k in manifest.child) {
    if (manifest.child[k].element && manifest.child[k].element.name === 'activity') {
      for (const attrIdx in manifest.child[k].element.attribute) {
        if (manifest.child[k].element.attribute[attrIdx].value === activity) 
        {
            var count = 0
            for (const childIdx in manifest.child[k].element.child )
            {
                //console.log( JSON.stringify(manifest.child[k].element.child[childIdx]) )
                var element = manifest.child[k].element.child[childIdx].element
                if( element && element.name == "intent-filter" )
                {
                    //console.log( JSON.stringify(element) )
                    //ok: if( count==idx )
                    if( indexes.includes(count) )
                    {
                        manifest.child[k].element.child.splice(childIdx,1)
                        deletes++
                    }
                    count++
                }
                
            }
        }
      }
    }
  }
  return deletes
}


module.exports = {
  replacePackageName,
  getElementsAtPath,
  setAttributesAtPath,
  deleteActivityByName,
  deleteServiceByName,
  deletePermissions,
  deleteUnsusedPermissions,
  deleteUnsusedServices,
  deleteIntentByIndex
}


