
//Todo: Transparent theme options, more build.json options
//Note: This is called twice if building aab file twice in row (should really run new instance)

var fs = require('fs')
var protobuf = require('protobufjs')
var helpers = require('aabutil')


//Permissions map.
var permsMap = { 
    "Network" : ["android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE",
                 "android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE", 
                 "android.permission.CHANGE_WIFI_MULTICAST_STATE", "android.permission.CHANGE_NETWORK_STATE" ],
    "Bluetooth" : ["android.permission.BLUETOOTH", "android.permission.BLUETOOTH_ADMIN"],
    "Camera" : ["android.permission.CAMERA", "android.permission.FLASHLIGHT", "android.permission.RECORD_VIDEO"],
    "Vibrate" : ["android.permission.VIBRATE"],
    "Storage" : ["android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"],
    "License" : ["android.permission.CHECK_LICENSE"],
    "WakeLock" : ["android.permission.WAKE_LOCK"],
    "Power" : ["android.permission.DEVICE_POWER"],
    "Shortcut" : ["android.permission.INSTALL_SHORTCUT"],
    "Location" : ["android.permission.ACCESS_FINE_LOCATION","android.permission.ACCESS_COARSE_LOCATION"],
    "SMS" : ["android.permission.SEND_SMS","android.permission.RECEIVE_SMS"],
    "Contacts" : ["android.permission.READ_CONTACTS"],
    "Accounts" : ["android.permission.GET_ACCOUNTS"],
    "Vending" : ["com.android.vending.BILLING","com.android.vending.CHECK_LICENSE"],
    "Record" : ["android.permission.RECORD_AUDIO"],
    "Phone" : ["android.permission.CALL_PHONE", "android.permission.READ_PHONE_STATE", 
            "android.permission.MODIFY_PHONE_STATE", "android.permission.ACCESS_COARSE_LOCATION"],
    "Calendar" : ["android.permission.READ_CALENDAR", "android.permission.WRITE_CALENDAR"],
    "NFC" : ["android.permission.NFC"],
    "SysWin" : ["android.permission.SYSTEM_ALERT_WINDOW"],
    "Unlock" : ["android.permission.DISABLE_KEYGUARD"],
    "Settings" : ["android.permission.WRITE_SETTINGS"],
    "Wallpaper" : ["android.permission.BIND_WALLPAPER"],
    "Install" : ["android.permission.REQUEST_INSTALL_PACKAGES"],
    "Service" : ["android.permission.FOREGROUND_SERVICE"],
    "Tasks" : ["android.permission.REORDER_TASKS"],
    "Alarms" : ["android.permission.SET_ALARM"],
    "MockLoc" : ["android.permission.ACCESS_MOCK_LOCATION"],
    "Biometric" : ["android.permission.USE_FINGERPRINT", "android.permission.USE_BIOMETRIC"],
    "FullIntent" : ["android.permission.USE_FULL_SCREEN_INTENT"],
    "Packages" : ["android.permission.QUERY_ALL_PACKAGES"],
    "Notify" : ["android.permission.POST_NOTIFICATIONS"]
}

  
//Modify the Android manifest
modManifest = async function( options )
{
    //Set build defaults.
    options.build = {}
    options.build.targetSdkVersion = 34
    //options.build.pathPattern = ".gif,.doc"
    //options.build.urlScheme = "https"
    //options.build.urlHost = "mywebsite.com"
    //options.build.urlPathPrefix = "/mobile,/test"

    //Load 'manifest' section of build.json here.
    console.log( "Loading build.json file" )
    if( options.buildFile && fs.existsSync(options.buildFile) ) {
        try {
            var buildJson = JSON.parse( fs.readFileSync( options.buildFile ) )
            options.build = buildJson.manifest ? buildJson.manifest : {}
        } catch(e) { console.log( "Bad build.json file!" ) }
    }

    console.log( "Loading proto file" )
    var proto = await protobuf.load( options.protoFile )
    //console.log( proto )
    
    //Obtain a message type
    var ProtobufXml = proto.lookupType('aapt.pb.XmlNode')
    var buffer = fs.readFileSync( options.manifestFile )
    var message = ProtobufXml.decode( buffer )
    
    //Replace package name.
    console.log(`changing package name from ${options.oldPackageName} to ${options.newPackageName}`)
    helpers.replacePackageName( message, options.oldPackageName, options.newPackageName )
    
    //Update version numbers.
    console.log( `changing version to ${options.newVersion}` )
    //console.log( helpers.getElementsAtPath( message, "element.attribute.versionCode" ) )
    //var verNum = options.newVersion.replace(",","").replace(".","")
    var verNum = Math.round(options.newVersion*100)
    helpers.setAttributesAtPath( message, "element.attribute", { "versionCode":verNum.toString(), "versionName":options.newVersion.toString() } )

    //Update min and target SDKs
    if( options.build.minSdkVersion )
        helpers.setAttributesAtPath( message, "element.uses-sdk.attribute", { "minSdkVersion":options.build.minSdkVersion.toString() } )
    if( options.build.targetSdkVersion )
        helpers.setAttributesAtPath( message, "element.uses-sdk.attribute", { "targetSdkVersion":options.build.targetSdkVersion.toString() } )

    //Update app and launcher label.
    //console.log( helpers.getElementsAtPath( message, "element.application.attribute.label" ) )
    helpers.setAttributesAtPath( message, "element.application.attribute", { "label":options.label } )
    helpers.setAttributesAtPath( message, "element.application.activity[0].attribute", { "label":options.label } )

    //Update file content provider.
    helpers.setAttributesAtPath( message, "element.application.provider[0].attribute", { "authorities":options.newPackageName+".file.provider" } )
    
    //Delete unused permissions
    var perms = []
    for( p in options.permissions ) {
        var andPerms = permsMap[options.permissions[p]]
        for( r in andPerms ) {
            var perm = andPerms[r].replace("android.permission.","").replace("com.android.vending.","")
            if( !options.build.removePermissions || !options.build.removePermissions.includes(perm) )
                perms = perms.concat( andPerms[r] )
        }
    }
    helpers.deleteUnsusedPermissions( message, perms )
    
    //Enable home screen mode if required.
    if( options.build.homeScreen ) {
        var intentFilt0_cat1 = "element.application.activity[0].intent-filter[0].category[1].attribute"
        helpers.setAttributesAtPath( message, intentFilt0_cat1, { "name":"android.intent.category.HOME" } )
    }

    //Modify pathPattern if file sharing required.
    //console.log( JSON.stringify(helpers.getElementsAtPath( message, intentFilt2+".data[2].attribute" ),null,4) )
    if( typeof options.build.pathPattern == 'string' )
    {
        var intentFilt2 = "element.application.activity[0].intent-filter[2]"
        var intentFilt3 = "element.application.activity[0].intent-filter[3]"
        var intentFilt4 = "element.application.activity[0].intent-filter[4]"
        var pathPattern = options.build.pathPattern.split(",")
        for( var i=0; i< pathPattern.length; i++ ) {
            var pat = pathPattern[i].trim()
            helpers.setAttributesAtPath( message, intentFilt2+".data["+(i+1)+"].attribute", { "pathPattern": pat } )
            helpers.setAttributesAtPath( message, intentFilt3+".data["+(i)+"].attribute", { "pathPattern": pat } )
            helpers.setAttributesAtPath( message, intentFilt4+".data["+(i+2)+"].attribute", { "pathPattern": pat } )
        }
    }

    //Modify urlScheme if file required.
    if( typeof options.build.urlScheme == 'string' )
    {
        var intentFilt7 = "element.application.activity[0].intent-filter[7]"
        var urlScheme = options.build.urlScheme.split(",")
        for( var i=0; i< urlScheme.length; i++ ) {
            var pat = urlScheme[i].trim()
            helpers.setAttributesAtPath( message, intentFilt7+".data["+(i)+"].attribute", { "scheme": pat } )
        }
    }

    //Modify urlHost if file required.
    if( typeof options.build.urlHost  == 'string' )
    {
        var intentFilt7 = "element.application.activity[0].intent-filter[7]"
        var urlHost = options.build.urlHost.split(",")
        for( var i=0; i< urlHost.length; i++ ) {
            var pat = urlHost[i].trim()
            helpers.setAttributesAtPath( message, intentFilt7+".data["+(i)+"].attribute", { "host": pat } )
        }
    }

    //Modify urlPathPrefix if file required.
    if( typeof options.build.urlPathPrefix  == 'string' )
    {
        var intentFilt7 = "element.application.activity[0].intent-filter[7]"
        var urlPathPrefix = options.build.urlPathPrefix.split(",")
        for( var i=0; i< urlPathPrefix.length; i++ ) {
            var pat = urlPathPrefix[i].trim()
            helpers.setAttributesAtPath( message, intentFilt7+".data["+(i)+"].attribute", { "pathPrefix": pat } )
        }
    }

    //Delete unused activities
    if( !options.options.includes("TV") )
        helpers.deleteActivityByName( message, "com.smartphoneremote.ioioscript.TvActivity" )

    //Delete unused services
    if( !options.options.includes("Wallpaper") )
            helpers.deleteServiceByName( message, "com.smartphoneremote.ioioscript.DSWallpaperService" )

    if( !options.options.includes("Beacon") )
            helpers.deleteServiceByName( message, "com.uriio.beacons.BleService" )

    if( !options.options.includes("NotifyService") )
        helpers.deleteServiceByName( message, "com.smartphoneremote.ioioscript.DSNotifyService" )

    if( !options.options.includes("Job") )
        helpers.deleteServiceByName( message, "com.smartphoneremote.ioioscript.DSJobService" )
        
    //Delete unused intent filters.
    var offset = 0
    if( !options.options.includes("Launch") || options.build.launcher==false )
        offset += helpers.deleteIntentByIndex( message, "com.smartphoneremote.androidscriptfree.AndroidScriptFree", [0],0 )
        
    if( !options.options.includes("Share") ) 
        offset += helpers.deleteIntentByIndex( message, "com.smartphoneremote.androidscriptfree.AndroidScriptFree", [1,2,3,4],-offset )
    
    if( !options.options.includes("USB") )
        offset += helpers.deleteIntentByIndex( message, "com.smartphoneremote.androidscriptfree.AndroidScriptFree", [5,6],-offset )
   
    if( /*!options.options.includes("URL") &&*/ options.build.urlHost==null )
        offset += helpers.deleteIntentByIndex( message, "com.smartphoneremote.androidscriptfree.AndroidScriptFree", [7],-offset )

     if( !options.options.includes("NDEF") )
            offset += helpers.deleteIntentByIndex( message, "com.smartphoneremote.androidscriptfree.AndroidScriptFree", [8],-offset )
   
    //Dump final manifest file to JSON format for debugging.
    fs.writeFileSync( options.jsonFile, JSON.stringify(message, null, 4) )
    //console.log( message )
    
    //Output new manifest file    
    console.log(`writing '${options.output}'`)
    const reenc = ProtobufXml.create(message)
    const pbBuffer = ProtobufXml.encode(reenc).finish()
    fs.writeFileSync( options.output, pbBuffer )
    console.log( "done manifest!" )
}

modAssets = async function( options )
{
    console.log( "Loading proto file" )
    var proto = await protobuf.load( options.protoFile )
    //console.log( proto )
    
    //Load assets file.
    var Assets = proto.lookupType('android.bundle.Assets')
    var buffer = fs.readFileSync( options.assetsFile )
    var message = Assets.decode( buffer )
    
    //Remove unwanted assets file from list.
    var i = message.directory.length
    while( i-- ) {
        for( var f in options.assetFilters ) {
            if( message.directory[i].path.startsWith(options.assetFilters[f]) ) {
                message.directory.splice(i,1)
                break
            }
        }
    }
    
    //Add user asset file to assets list.
    var TargetedAssetsDirectory = proto.lookupType('android.bundle.TargetedAssetsDirectory')
    var AssetsDirectoryTargeting = proto.lookupType('android.bundle.AssetsDirectoryTargeting')
    var target = AssetsDirectoryTargeting.create( {} )
    var dir = TargetedAssetsDirectory.create( { "path": "assets/user", "targeting" : target } );
    message.directory.unshift( dir ) 
      
    //Dump final assets file to JSON format for debugging.
    fs.writeFileSync( options.jsonFile, JSON.stringify(message, null, 4) )
    //console.log( message )
    
     //Output new manifest file    
    console.log(`writing '${options.output}'`)
    const reenc = Assets.create(message)
    const pbBuffer = Assets.encode(reenc).finish()
    fs.writeFileSync( options.output, pbBuffer )
  
    console.log( "done assets!" )
}

console.log( "loaded aab.js" )



