/*!
 * Copyright 2014 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @namespace google.pubsub.v1
 */
/**
 * @namespace google.protobuf
 */
/**
 * The default export of the `@google-cloud/pubsub` package is the
 * {@link PubSub} class.
 *
 * See {@link PubSub} and {@link ClientConfig} for client methods and
 * configuration options.
 *
 * @module {PubSub} @google-cloud/pubsub
 * @alias nodejs-pubsub
 *
 * @example Install the client library with <a href="https://www.npmjs.com/">npm</a>:
 * ```
 * npm install @google-cloud/pubsub
 *
 * ```
 * @example Import the client library
 * ```
 * const {PubSub} = require('@google-cloud/pubsub');
 *
 * ```
 * @example Create a client that uses <a href="https://cloud.google.com/docs/authentication/production#providing_credentials_to_your_application">Application Default Credentials (ADC)</a>:
 * ```
 * const pubsub = new PubSub();
 *
 * ```
 * @example Create a client with <a href="https://cloud.google.com/docs/authentication/production#obtaining_and_providing_service_account_credentials_manually">explicit credentials</a>:
 * ```
 * const pubsub = new PubSub({
 *   projectId: 'your-project-id',
 *   keyFilename: '/path/to/keyfile.json'
 * });
 *
 * ```
 * @example <caption>include:samples/quickstart.js</caption>
 * region_tag:pubsub_quickstart_create_topic
 * Full quickstart example:
 */
/**
 * Reference to internal generated clients, advanced use only.
 *
 * @name PubSub.v1
 * @see v1.PublisherClient
 * @see v1.SubscriberClient
 * @type {object}
 * @property {constructor} PublisherClient
 *     Reference to {@link v1.PublisherClient}.
 * @property {constructor} SubscriberClient
 *     Reference to {@link v1.SubscriberClient}.
 */
/**
 * Reference to internal generated clients, advanced use only.
 *
 * @name module:@google-cloud/pubsub.v1
 * @see v1.PublisherClient
 * @see v1.SubscriberClient
 * @type {object}
 * @property {constructor} PublisherClient
 *     Reference to {@link v1.PublisherClient}.
 * @property {constructor} SubscriberClient
 *     Reference to {@link v1.SubscriberClient}.
 */
import * as v1 from './v1';
export { v1 };
export { ServiceError, CallOptions } from 'google-gax';
export { Policy, GetPolicyCallback, SetPolicyCallback, SetPolicyResponse, GetPolicyResponse, IamPermissionsMap, TestIamPermissionsResponse, TestIamPermissionsCallback, IAM, } from './iam';
export { Attributes, PublishCallback, PublishOptions } from './publisher';
export { BatchPublishOptions } from './publisher/message-batch';
export { PublishError } from './publisher/publish-error';
export { FlowControlOptions } from './publisher/flow-control';
export { PageOptions, GetSnapshotsCallback, GetSnapshotsResponse, GetSubscriptionsCallback, GetSubscriptionsResponse, GetTopicsCallback, GetTopicsResponse, EmptyCallback, EmptyResponse, ExistsCallback, ExistsResponse, PubSub, ClientConfig, } from './pubsub';
export { CreateSnapshotCallback, CreateSnapshotResponse, SeekCallback, SeekResponse, Snapshot, } from './snapshot';
export { Message, SubscriberOptions } from './subscriber';
export { Schema, CreateSchemaResponse, ISchema, SchemaType, SchemaTypes, ICreateSchemaRequest, SchemaEncoding, SchemaView, SchemaViews, Encodings, SchemaMessageMetadata, } from './schema';
export { PushConfig, SubscriptionMetadata, SubscriptionOptions, SubscriptionCloseCallback, CreateSubscriptionOptions, CreateSubscriptionCallback, CreateSubscriptionResponse, GetSubscriptionOptions, GetSubscriptionCallback, GetSubscriptionResponse, GetSubscriptionMetadataCallback, GetSubscriptionMetadataResponse, SetSubscriptionMetadataCallback, SetSubscriptionMetadataResponse, Subscription, AckError, AckResponse, AckResponses, } from './subscription';
export { CreateTopicCallback, CreateTopicResponse, GetTopicCallback, GetTopicResponse, GetTopicOptions, GetTopicMetadataCallback, GetTopicMetadataResponse, GetTopicSubscriptionsCallback, GetTopicSubscriptionsResponse, SetTopicMetadataCallback, SetTopicMetadataResponse, Topic, TopicMetadata, } from './topic';
export { Duration, TotalOfUnit, DurationLike } from './temporal';
export { DebugMessage } from './debug';
import * as protos from '../protos/protos';
export { protos };
