"use strict";
/*!
 * Copyright 2014 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.protos = exports.DebugMessage = exports.Duration = exports.Topic = exports.AckResponses = exports.AckError = exports.Subscription = exports.Encodings = exports.SchemaViews = exports.SchemaTypes = exports.Schema = exports.Message = exports.Snapshot = exports.PubSub = exports.PublishError = exports.IAM = exports.v1 = void 0;
/**
 * @namespace google.pubsub.v1
 */
/**
 * @namespace google.protobuf
 */
/**
 * The default export of the `@google-cloud/pubsub` package is the
 * {@link PubSub} class.
 *
 * See {@link PubSub} and {@link ClientConfig} for client methods and
 * configuration options.
 *
 * @module {PubSub} @google-cloud/pubsub
 * @alias nodejs-pubsub
 *
 * @example Install the client library with <a href="https://www.npmjs.com/">npm</a>:
 * ```
 * npm install @google-cloud/pubsub
 *
 * ```
 * @example Import the client library
 * ```
 * const {PubSub} = require('@google-cloud/pubsub');
 *
 * ```
 * @example Create a client that uses <a href="https://cloud.google.com/docs/authentication/production#providing_credentials_to_your_application">Application Default Credentials (ADC)</a>:
 * ```
 * const pubsub = new PubSub();
 *
 * ```
 * @example Create a client with <a href="https://cloud.google.com/docs/authentication/production#obtaining_and_providing_service_account_credentials_manually">explicit credentials</a>:
 * ```
 * const pubsub = new PubSub({
 *   projectId: 'your-project-id',
 *   keyFilename: '/path/to/keyfile.json'
 * });
 *
 * ```
 * @example <caption>include:samples/quickstart.js</caption>
 * region_tag:pubsub_quickstart_create_topic
 * Full quickstart example:
 */
/**
 * Reference to internal generated clients, advanced use only.
 *
 * @name PubSub.v1
 * @see v1.PublisherClient
 * @see v1.SubscriberClient
 * @type {object}
 * @property {constructor} PublisherClient
 *     Reference to {@link v1.PublisherClient}.
 * @property {constructor} SubscriberClient
 *     Reference to {@link v1.SubscriberClient}.
 */
/**
 * Reference to internal generated clients, advanced use only.
 *
 * @name module:@google-cloud/pubsub.v1
 * @see v1.PublisherClient
 * @see v1.SubscriberClient
 * @type {object}
 * @property {constructor} PublisherClient
 *     Reference to {@link v1.PublisherClient}.
 * @property {constructor} SubscriberClient
 *     Reference to {@link v1.SubscriberClient}.
 */
const v1 = require("./v1");
exports.v1 = v1;
var iam_1 = require("./iam");
Object.defineProperty(exports, "IAM", { enumerable: true, get: function () { return iam_1.IAM; } });
var publish_error_1 = require("./publisher/publish-error");
Object.defineProperty(exports, "PublishError", { enumerable: true, get: function () { return publish_error_1.PublishError; } });
var pubsub_1 = require("./pubsub");
Object.defineProperty(exports, "PubSub", { enumerable: true, get: function () { return pubsub_1.PubSub; } });
var snapshot_1 = require("./snapshot");
Object.defineProperty(exports, "Snapshot", { enumerable: true, get: function () { return snapshot_1.Snapshot; } });
var subscriber_1 = require("./subscriber");
Object.defineProperty(exports, "Message", { enumerable: true, get: function () { return subscriber_1.Message; } });
var schema_1 = require("./schema");
Object.defineProperty(exports, "Schema", { enumerable: true, get: function () { return schema_1.Schema; } });
Object.defineProperty(exports, "SchemaTypes", { enumerable: true, get: function () { return schema_1.SchemaTypes; } });
Object.defineProperty(exports, "SchemaViews", { enumerable: true, get: function () { return schema_1.SchemaViews; } });
Object.defineProperty(exports, "Encodings", { enumerable: true, get: function () { return schema_1.Encodings; } });
var subscription_1 = require("./subscription");
Object.defineProperty(exports, "Subscription", { enumerable: true, get: function () { return subscription_1.Subscription; } });
Object.defineProperty(exports, "AckError", { enumerable: true, get: function () { return subscription_1.AckError; } });
Object.defineProperty(exports, "AckResponses", { enumerable: true, get: function () { return subscription_1.AckResponses; } });
var topic_1 = require("./topic");
Object.defineProperty(exports, "Topic", { enumerable: true, get: function () { return topic_1.Topic; } });
var temporal_1 = require("./temporal");
Object.defineProperty(exports, "Duration", { enumerable: true, get: function () { return temporal_1.Duration; } });
var debug_1 = require("./debug");
Object.defineProperty(exports, "DebugMessage", { enumerable: true, get: function () { return debug_1.DebugMessage; } });
if (process.env.DEBUG_GRPC) {
    console.info('gRPC logging set to verbose');
    const grpc = require('google-gax').grpc;
    grpc.setLogger(console);
    grpc.setLogVerbosity(grpc.logVerbosity.DEBUG);
}
const protos = require("../protos/protos");
exports.protos = protos;
//# sourceMappingURL=index.js.map