"use strict";
// Implements 'spaceDelimited' and 'pipeDelimited' from OAS 3.
Object.defineProperty(exports, "__esModule", { value: true });
exports.spaceDelimitedParser = exports.pipeDelimitedParser = exports.generateDelimitedParser = void 0;
function generateDelimitedParser(delimiter) {
    return function delimitedParser(location, rawParamValues) {
        const value = rawParamValues[location.name];
        if (value === null || value === undefined) {
            return value;
        }
        else if (Array.isArray(value)) {
            // Client is supposed to send us a delimited string, but it looks
            // like they sent us multiple copies of the var instead.  Just
            // decode the array.
            return value.map(decodeURIComponent);
        }
        else {
            return decodeURIComponent(value).split(delimiter);
        }
    };
}
exports.generateDelimitedParser = generateDelimitedParser;
exports.pipeDelimitedParser = generateDelimitedParser('|');
exports.spaceDelimitedParser = generateDelimitedParser(' ');
//# sourceMappingURL=delimitedParser.js.map