"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getErrorMessage = exports.getValidator = void 0;
const fs = require("fs");
const path = require("path");
const Ajv = require("ajv");
const ajv = new Ajv();
let _VALIDATOR = undefined;
function getValidator() {
    if (!_VALIDATOR) {
        const schemaStr = fs.readFileSync(path.resolve(__dirname, "../schema/firebase-config.json"), "utf-8");
        const schema = JSON.parse(schemaStr);
        _VALIDATOR = ajv.compile(schema);
    }
    return _VALIDATOR;
}
exports.getValidator = getValidator;
function getErrorMessage(e) {
    if (e.keyword === "additionalProperties") {
        return `Object "${e.dataPath}" in "firebase.json" has unknown property: ${JSON.stringify(e.params)}`;
    }
    else if (e.keyword === "required") {
        return `Object "${e.dataPath}" in "firebase.json" is missing required property: ${JSON.stringify(e.params)}`;
    }
    else {
        return `Field "${e.dataPath}" in "firebase.json" is possibly invalid: ${e.message}`;
    }
}
exports.getErrorMessage = getErrorMessage;
