"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConfig = exports.getBootstrapScript = void 0;
const path_1 = require("path");
const { dynamicImport } = require(true && "../../dynamicImport");
function getBootstrapScript() {
    return `const entry = import('./entry.mjs');\nexport const handle = async (req, res) => (await entry).handler(req, res)`;
}
exports.getBootstrapScript = getBootstrapScript;
async function getConfig(cwd) {
    const astroDirectory = (0, path_1.dirname)(require.resolve("astro/package.json", { paths: [cwd] }));
    const { openConfig } = await dynamicImport((0, path_1.join)(astroDirectory, "dist", "core", "config", "config.js"));
    const logging = undefined;
    const { astroConfig: config } = await openConfig({ cmd: "build", cwd, logging });
    return {
        outDir: (0, path_1.relative)(cwd, config.outDir.pathname),
        publicDir: (0, path_1.relative)(cwd, config.publicDir.pathname),
        output: config.output,
        adapter: config.adapter,
    };
}
exports.getConfig = getConfig;
