"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createBuild = exports.createStack = exports.API_VERSION = void 0;
const apiv2_1 = require("../apiv2");
const api_1 = require("../api");
exports.API_VERSION = "v2";
const client = new apiv2_1.Client({
    urlPrefix: api_1.frameworksOrigin,
    auth: true,
    apiVersion: exports.API_VERSION,
});
async function createStack(projectId, location, stackInput) {
    const stackId = stackInput.name;
    const res = await client.post(`projects/${projectId}/locations/${location}/stacks`, stackInput, { queryParams: { stackId } });
    return res.body;
}
exports.createStack = createStack;
async function createBuild(projectId, location, stackId, buildInput) {
    const buildId = buildInput.name;
    const res = await client.post(`projects/${projectId}/locations/${location}/stacks/${stackId}/builds`, buildInput, { queryParams: { buildId } });
    return res.body;
}
exports.createBuild = createBuild;
