"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createStack = exports.doSetup = void 0;
const clc = require("colorette");
const utils = require("../../../utils");
const logger_1 = require("../../../logger");
const prompt_1 = require("../../../prompt");
const constants_1 = require("./constants");
const repo_1 = require("./repo");
const poller = require("../../../operation-poller");
const api_1 = require("../../../api");
const gcp = require("../../../gcp/frameworks");
const frameworks_1 = require("../../../gcp/frameworks");
const frameworksPollerOptions = {
    apiOrigin: api_1.frameworksOrigin,
    apiVersion: frameworks_1.API_VERSION,
    masterTimeout: 25 * 60 * 1000,
    maxBackoff: 10000,
};
async function doSetup(setup) {
    var _a, _b;
    const projectId = (_b = (_a = setup === null || setup === void 0 ? void 0 : setup.rcfile) === null || _a === void 0 ? void 0 : _a.projects) === null || _b === void 0 ? void 0 : _b.default;
    setup.frameworks = {};
    utils.logBullet("First we need a few details to create your service.");
    await (0, prompt_1.promptOnce)({
        name: "serviceName",
        type: "input",
        default: "acme-inc-web",
        message: "Create a name for your service [6-32 characters]",
    }, setup.frameworks);
    await (0, prompt_1.promptOnce)({
        name: "region",
        type: "list",
        default: constants_1.DEFAULT_REGION,
        message: "Please select a region " +
            `(${clc.yellow("info")}: Your region determines where your backend is located):\n`,
        choices: constants_1.ALLOWED_REGIONS,
    }, setup.frameworks);
    utils.logSuccess(`Region set to ${setup.frameworks.region}.`);
    logger_1.logger.info(clc.bold(`\n${clc.white("===")} Deploy Setup`));
    await (0, prompt_1.promptOnce)({
        name: "deployMethod",
        type: "list",
        default: constants_1.DEFAULT_DEPLOY_METHOD,
        message: "How do you want to deploy",
        choices: constants_1.ALLOWED_DEPLOY_METHODS,
    }, setup.frameworks);
    if (setup.frameworks.deployMethod === "github") {
        const cloudBuildConnRepo = await (0, repo_1.linkGitHubRepository)(projectId, setup.frameworks.region, setup.frameworks.serviceName);
        toStack(cloudBuildConnRepo, setup.frameworks.serviceName);
    }
}
exports.doSetup = doSetup;
function toStack(cloudBuildConnRepo, stackId) {
    return {
        name: stackId,
        codebase: { repository: cloudBuildConnRepo.name, rootDirectory: "/" },
        labels: {},
    };
}
async function createStack(projectId, location, stackInput) {
    const op = await gcp.createStack(projectId, location, stackInput);
    const stack = await poller.pollOperation(Object.assign(Object.assign({}, frameworksPollerOptions), { pollerName: `create-${projectId}-${location}-${stackInput.name}`, operationResourceName: op.name }));
    return stack;
}
exports.createStack = createStack;
