"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.logger = void 0;
const winston = require("winston");

function expandErrors(logger) {
    const oldLogFunc = logger.log.bind(logger);
    const newLogFunc = function (levelOrEntry, message, ...meta) {
        if (message && message instanceof Error) {
            message = message.stack || message.message;
            return oldLogFunc(levelOrEntry, message, ...meta);
        }
        return oldLogFunc(levelOrEntry, message, ...meta);
    };
    logger.log = newLogFunc;
    return logger;
}
function annotateDebugLines(logger) {
    const debug = logger.debug.bind(logger);
    const newDebug = function (message, ...meta) {
        /*dh if (typeof message === "string") {
            message = `[${new Date().toISOString()}] ${message || ""}`;
        }
        return debug(message, ...meta);
        */
        return null
    };
    logger.debug = newDebug;
    return logger;
}

//dh: Allow clearing of logs 
//(else we get duplicate entries cos we are not exiting process and/or a bug in logging code)
function reset() { 
    const rawLogger = winston.createLogger();
    rawLogger.add(new winston.transports.Console({ silent: true }));
    rawLogger.exitOnError = false;
    rawLogger.reset = reset;
    exports.logger = annotateDebugLines(expandErrors(rawLogger));
}

const rawLogger = winston.createLogger();
rawLogger.add(new winston.transports.Console({ silent: true }));
rawLogger.exitOnError = false;
rawLogger.reset = reset;
exports.logger = annotateDebugLines(expandErrors(rawLogger));



