import { JsonStringPointer, UriFragmentIdentifierPointer, Pointer, RelativeJsonPointer, PathSegment, PathSegments, Decoder } from './types';
export declare function replace(source: string, find: string, repl: string): string;
export declare function decodeFragmentSegments(segments: PathSegments): PathSegments;
export declare function encodeFragmentSegments(segments: PathSegments): PathSegments;
export declare function decodePointerSegments(segments: PathSegments): PathSegments;
export declare function encodePointerSegments(segments: PathSegments): PathSegments;
export declare function decodePointer(ptr: Pointer): PathSegments;
export declare function encodePointer(path: PathSegments): JsonStringPointer;
export declare function decodeUriFragmentIdentifier(ptr: UriFragmentIdentifierPointer): PathSegments;
export declare function encodeUriFragmentIdentifier(path: PathSegments): UriFragmentIdentifierPointer;
export declare function decodeRelativePointer(ptr: RelativeJsonPointer): PathSegments;
export declare function toArrayIndexReference(arr: readonly unknown[], idx: PathSegment): number;
export declare type Dereference = (it: unknown) => unknown;
export declare function compilePointerDereference(path: PathSegments): Dereference;
export declare function setValueAtPath(target: unknown, val: unknown, path: PathSegments, force?: boolean): unknown;
export declare function unsetValueAtPath(target: unknown, path: PathSegments): unknown;
export declare function looksLikeFragment(ptr: Pointer): boolean;
export declare function pickDecoder(ptr: Pointer): Decoder;
export declare function decodePtrInit(ptr: Pointer | PathSegments): PathSegments;
