export interface Configuration {
    public?: string;
    cleanUrls?: boolean | string[];
    rewrites?: Array<Rewrite>;
    redirects?: Array<Redirect>;
    headers?: Array<Header>;
    trailingSlash?: boolean;
    i18n?: {
        root: string;
    };
    errorPage?: string;
}
export interface Rewrite {
    source: string;
    destination: string;
}
export interface Redirect {
    source: string;
    destination: string;
    type?: number;
}
export interface Header {
    source: string;
    headers: Array<{
        key: string;
        value: string;
    }>;
}
